export const ErrorImage = () => (
	<svg width="292" height="132" viewBox="0 0 292 132" fill="none">
		<rect width="292" height="129" transform="translate(0 2)" fill="white" />
		<path
			d="M142.867 20.0408C117.693 10.4324 85.5969 21.5032 71.6941 43.8734C69.6916 47.1067 65.2633 53.0134 65.0688 63.2959C64.7026 83.0612 80.4133 101.615 96.2385 108.253C99.6713 109.693 114.055 110.173 142.867 111.132C149.538 111.35 156.209 111.532 164.608 114.56C169.311 116.262 171.256 117.759 176.566 119.13C182.264 120.545 188.122 121.209 193.993 121.107C214.933 121.187 230.758 108.539 231.25 90.259C231.502 80.8905 233.367 70.2881 225.529 62.9989C216.031 54.2131 206.179 58.2918 189.713 54.0645C164.643 47.6437 166.645 29.078 142.867 20.0408Z"
			fill="#EFF5FE"
		/>
		<g clipPath="url(#clip0_1253_33753)">
			<path
				d="M170.578 37.6797L199.012 17.0596L170.578 37.6797Z"
				fill="white"
			/>
			<path
				d="M199.115 16.5345L170.636 37.2217L171.075 37.8218L199.554 17.1347L199.115 16.5345Z"
				fill="black"
			/>
			<rect
				x="29.6226"
				y="53.7681"
				width="21.8249"
				height="21.515"
				fill="url(#pattern0_1253_33753)"
			/>
			<path
				d="M202.968 122.277C198.143 122.277 190.647 119.804 181.123 114.974C166.882 107.748 149.631 96.0955 132.534 82.1723C115.436 68.2491 100.558 53.6813 90.6108 41.2495C80.6631 28.8178 76.7555 19.5902 79.9106 15.7413C86.404 7.8127 119.691 24.5744 155.7 53.8929C191.708 83.2115 214.826 112.395 208.332 120.285C207.271 121.633 205.457 122.277 202.968 122.277ZM85.3523 14.5097C83.1042 14.5097 81.4929 15.0774 80.5281 16.2609C77.6239 19.7152 81.5219 28.6638 91.1897 40.7876C101.108 53.2194 115.957 67.7295 133.016 81.595C150.075 95.4604 167.278 107.103 181.471 114.31C195.316 121.334 204.897 123.355 207.753 119.862C213.88 112.376 190.319 83.0479 155.227 54.4318C125.702 30.4246 97.2779 14.4616 85.362 14.4616L85.3523 14.5097Z"
				fill="black"
			/>
			<path
				d="M143.33 101.166C138.897 101.186 134.505 100.321 130.412 98.622C126.319 96.9233 122.609 94.4252 119.498 91.2749C116.318 88.0598 113.814 84.2432 112.134 80.0494C110.454 75.8557 109.632 71.3693 109.715 66.854C109.956 47.6772 125.625 31.8681 144.662 31.6083H145.134C149.569 31.5881 153.963 32.4528 158.057 34.1515C162.152 35.8503 165.864 38.3487 168.976 41.4998C172.156 44.7147 174.658 48.5315 176.337 52.7254C178.015 56.9194 178.836 61.4058 178.75 65.9207C178.518 85.0975 162.849 100.907 143.803 101.166H143.33ZM144.44 49.1012C139.836 49.2129 135.454 51.0996 132.215 54.3652C128.977 57.6308 127.133 62.021 127.072 66.6135C127.025 68.8545 127.428 71.0822 128.256 73.1659C129.085 75.2496 130.322 77.1471 131.897 78.7469C133.446 80.3157 135.293 81.5596 137.331 82.4057C139.37 83.2517 141.557 83.6828 143.764 83.6734H143.996C148.599 83.5595 152.979 81.6719 156.218 78.4069C159.456 75.1418 161.3 70.753 161.363 66.1612C161.412 63.92 161.01 61.6918 160.182 59.6079C159.353 57.524 158.115 55.6266 156.539 54.0278C154.992 52.4584 153.146 51.214 151.11 50.3678C149.073 49.5217 146.887 49.091 144.681 49.1012H144.44Z"
				fill="black"
			/>
			<path
				d="M145.135 31.9834C149.521 31.9641 153.867 32.8199 157.916 34.5005C161.966 36.181 165.638 38.6524 168.716 41.7691C171.857 44.9479 174.329 48.7214 175.986 52.8676C177.643 57.0137 178.452 61.4485 178.364 65.911C178.142 84.8857 162.627 100.551 143.793 100.791H143.321C138.938 100.809 134.597 99.9528 130.551 98.274C126.505 96.5952 122.836 94.1273 119.759 91.015C116.62 87.8322 114.15 84.0566 112.493 79.9094C110.836 75.7622 110.026 71.327 110.11 66.8635C110.342 47.8791 125.857 32.224 144.691 31.9834H145.154H145.135ZM143.822 84.039H144.064C148.754 83.9178 153.216 81.9925 156.516 78.6658C159.816 75.3392 161.698 70.8688 161.769 66.19C161.813 63.8951 161.396 61.6146 160.542 59.4829C159.689 57.3512 158.416 55.4113 156.8 53.7775C155.216 52.1758 153.327 50.9062 151.245 50.0436C149.162 49.181 146.927 48.7428 144.671 48.7548H144.43C139.742 48.8785 135.284 50.8052 131.987 54.1318C128.691 57.4585 126.813 61.9274 126.744 66.6038C126.701 68.898 127.119 71.1777 127.974 73.308C128.829 75.4384 130.104 77.3761 131.723 79.0066C133.306 80.6097 135.194 81.8807 137.277 82.745C139.36 83.6092 141.595 84.0492 143.851 84.039H143.822ZM145.183 31.2329H144.71C125.413 31.4927 109.628 47.4365 109.396 66.8347C109.294 71.3508 110.096 75.8418 111.758 80.0443C113.419 84.2468 115.905 88.076 119.071 91.3071C122.236 94.5383 126.017 97.1063 130.191 98.8605C134.365 100.615 138.849 101.52 143.379 101.522H143.861C163.158 101.263 178.943 85.3187 179.175 65.9206C179.271 61.4077 178.463 56.921 176.798 52.7235C175.133 48.526 172.645 44.7021 169.479 41.476C166.313 38.2499 162.534 35.6863 158.362 33.9357C154.19 32.1851 149.709 31.2826 145.183 31.281V31.2329ZM143.851 83.2981C141.669 83.2985 139.509 82.8648 137.498 82.0224C135.486 81.18 133.663 79.9458 132.135 78.392C130.608 76.8382 129.407 74.9962 128.602 72.9737C127.797 70.9512 127.405 68.7889 127.449 66.6134C127.495 62.1159 129.294 57.8128 132.466 54.6146C135.637 51.4163 139.931 49.5736 144.44 49.4764H144.671C146.852 49.4823 149.009 49.9216 151.017 50.7687C153.025 51.6158 154.844 52.8536 156.366 54.4098C157.889 55.966 159.086 57.8093 159.886 59.832C160.686 61.8547 161.073 64.0162 161.026 66.19C160.979 70.6875 159.18 74.9905 156.009 78.1888C152.838 81.3871 148.544 83.2298 144.035 83.327L143.851 83.2981Z"
				fill="black"
			/>
			<path
				d="M109.589 72.9258C109.274 72.9278 108.961 72.8667 108.669 72.746C108.377 72.6254 108.113 72.4477 107.891 72.2234C107.643 71.9704 107.449 71.6689 107.323 71.3377C107.197 71.0065 107.14 70.6529 107.158 70.299L107.254 62.534C107.247 62.1899 107.307 61.8478 107.433 61.5272C107.558 61.2067 107.746 60.9141 107.986 60.6663C108.225 60.4186 108.512 60.2205 108.828 60.0836C109.145 59.9467 109.485 59.8736 109.831 59.8687H109.975L126.986 60.8309C127.49 60.9356 127.937 61.2246 128.239 61.6412C128.541 62.0578 128.675 62.5719 128.616 63.0824L128.539 69.1925C128.579 69.7172 128.429 70.2389 128.118 70.6639C127.807 71.0889 127.354 71.3893 126.841 71.5114L109.802 72.9258H109.589Z"
				fill="white"
			/>
			<path
				d="M109.83 60.2823H109.956L126.966 61.2445C127.671 61.2445 128.25 62.1393 128.24 63.1689L128.172 69.2789C128.172 70.2411 127.536 71.2033 126.812 71.2033L109.763 72.5504H109.589C109.322 72.5539 109.058 72.5037 108.811 72.4028C108.564 72.302 108.339 72.1526 108.152 71.9635C107.947 71.75 107.787 71.498 107.681 71.2221C107.575 70.9461 107.525 70.6519 107.534 70.3566L107.621 62.5819C107.615 62.2862 107.667 61.9922 107.774 61.7166C107.882 61.4409 108.043 61.1892 108.248 60.9756C108.453 60.762 108.699 60.5909 108.97 60.4719C109.242 60.353 109.534 60.2885 109.83 60.2823ZM109.83 59.5414C109.037 59.5565 108.282 59.8835 107.729 60.4511C107.176 61.0187 106.87 61.781 106.878 62.5723L106.782 70.347C106.763 70.7268 106.822 71.1063 106.955 71.4628C107.088 71.8193 107.291 72.1453 107.554 72.4212C107.816 72.6972 108.131 72.9174 108.481 73.0686C108.831 73.2198 109.208 73.2988 109.589 73.301H109.83L126.87 71.9058C127.477 71.7816 128.019 71.4422 128.395 70.9505C128.771 70.4588 128.956 69.8479 128.915 69.2308L128.992 63.1112C129.053 62.5054 128.882 61.8992 128.513 61.414C128.145 60.9287 127.606 60.6001 127.005 60.4939L109.995 59.5317L109.83 59.5414Z"
				fill="black"
			/>
			<path
				d="M160.881 71.001C160.346 70.9544 159.85 70.7007 159.501 70.2942C159.151 69.8878 158.974 69.3609 159.009 68.8264L159.086 62.7164C159.07 62.1691 159.259 61.6353 159.615 61.219C159.972 60.8028 160.471 60.5339 161.016 60.4648L178.229 59.7432C178.525 59.7425 178.818 59.8019 179.09 59.9177C179.362 60.0335 179.607 60.2033 179.811 60.4167C180.026 60.6353 180.194 60.8942 180.306 61.1784C180.419 61.4625 180.474 61.7662 180.468 62.0717L180.381 68.8842C180.381 69.513 180.133 70.1166 179.691 70.5649C179.248 71.0131 178.647 71.27 178.017 71.2801L160.881 71.001Z"
				fill="white"
			/>
			<path
				d="M178.239 60.1186C178.481 60.1182 178.72 60.1656 178.944 60.2581C179.168 60.3506 179.371 60.4863 179.541 60.6574C179.722 60.8415 179.864 61.0598 179.958 61.2994C180.052 61.5391 180.098 61.7952 180.091 62.0526L180.014 68.8651C180.011 69.4011 179.798 69.9146 179.418 70.2945C179.039 70.6745 178.525 70.8903 177.988 70.8954L160.891 70.6259C160.454 70.582 160.051 70.369 159.77 70.0326C159.488 69.6962 159.35 69.2633 159.385 68.8266L159.463 62.7166C159.432 62.2553 159.578 61.7996 159.872 61.4422C160.166 61.0847 160.585 60.8523 161.045 60.7921L178.152 60.0705H178.239V60.1186ZM178.239 59.3296H178.123L161.016 60.0512C160.373 60.1165 159.778 60.4212 159.351 60.9046C158.923 61.388 158.695 62.0145 158.71 62.6588L158.643 68.7689C158.622 69.0829 158.663 69.3979 158.764 69.6961C158.865 69.9942 159.024 70.2695 159.232 70.5063C159.44 70.743 159.693 70.9367 159.975 71.0761C160.258 71.2155 160.566 71.2979 160.881 71.3187L177.978 71.5881C178.709 71.5934 179.412 71.3116 179.935 70.8038C180.459 70.296 180.761 69.603 180.776 68.8747L180.853 62.0623C180.865 61.7147 180.807 61.3683 180.681 61.0437C180.556 60.7191 180.367 60.4228 180.125 60.1724C179.883 59.9221 179.593 59.7227 179.272 59.5862C178.952 59.4497 178.607 59.3788 178.258 59.3777L178.239 59.3296Z"
				fill="black"
			/>
			<path
				d="M140.899 51.8049C140.404 51.8539 139.908 51.7232 139.502 51.4369C139.096 51.1505 138.808 50.7277 138.689 50.2461L137.474 32.0218C137.446 31.6593 137.495 31.2951 137.616 30.9523C137.737 30.6094 137.929 30.2954 138.178 30.0301C138.438 29.7479 138.755 29.5227 139.107 29.3687C139.459 29.2146 139.839 29.1351 140.223 29.1352L148.319 29.0294C148.695 29.0188 149.069 29.088 149.417 29.2323C149.764 29.3766 150.077 29.5927 150.335 29.8665C150.571 30.1251 150.75 30.4297 150.861 30.761C150.972 31.0922 151.013 31.443 150.982 31.7909L149.322 50.0729C149.2 50.5822 148.899 51.0315 148.475 51.34C148.051 51.6486 147.53 51.7963 147.006 51.7568L140.899 51.8049Z"
				fill="white"
			/>
			<path
				d="M148.367 28.6639V29.4048C148.685 29.4002 149 29.4621 149.292 29.5864C149.585 29.7106 149.848 29.8946 150.065 30.1265C150.269 30.3518 150.423 30.6172 150.518 30.9056C150.612 31.1939 150.645 31.4988 150.615 31.8007L148.946 50.0827C148.888 50.7659 147.981 51.3625 147.016 51.3817L140.908 51.4587C139.944 51.4587 139.114 50.9102 139.075 50.2559L137.84 31.9932C137.82 31.6815 137.863 31.3689 137.967 31.0744C138.072 30.7799 138.235 30.5098 138.448 30.2804C138.675 30.0373 138.95 29.8434 139.255 29.711C139.561 29.5785 139.89 29.5103 140.223 29.5107L148.328 29.3952V28.6543L148.367 28.6639ZM148.328 28.6543L140.223 28.7601C139.798 28.7594 139.377 28.8454 138.987 29.0129C138.596 29.1804 138.244 29.4258 137.952 29.7341C137.66 30.0423 137.435 30.4069 137.289 30.8053C137.144 31.2038 137.082 31.6276 137.107 32.0509L138.323 50.2752C138.435 50.858 138.761 51.3781 139.238 51.7339C139.714 52.0897 140.306 52.2558 140.899 52.1996H140.947L147.016 52.1226C147.624 52.1636 148.226 51.9877 148.716 51.6263C149.206 51.2649 149.55 50.7417 149.689 50.1501L151.358 31.8681C151.404 31.455 151.36 31.0368 151.229 30.6421C151.098 30.2475 150.884 29.8857 150.6 29.5814C150.316 29.2772 149.969 29.0377 149.584 28.8793C149.198 28.721 148.783 28.6475 148.367 28.6639L148.328 28.6543Z"
				fill="black"
			/>
			<path
				d="M140.899 51.8049C140.404 51.8539 139.908 51.7232 139.502 51.4369C139.096 51.1505 138.808 50.7277 138.689 50.2461L137.474 32.0218C137.446 31.6593 137.495 31.2951 137.616 30.9523C137.737 30.6094 137.929 30.2954 138.178 30.0301C138.438 29.7479 138.755 29.5227 139.107 29.3687C139.459 29.2146 139.839 29.1351 140.223 29.1352L148.319 29.0294C148.695 29.0188 149.069 29.088 149.417 29.2323C149.764 29.3766 150.077 29.5927 150.335 29.8665C150.571 30.1251 150.75 30.4297 150.861 30.761C150.972 31.0922 151.013 31.443 150.982 31.7909L149.322 50.0729C149.2 50.5822 148.899 51.0315 148.475 51.34C148.051 51.6486 147.53 51.7963 147.006 51.7568L140.899 51.8049Z"
				fill="white"
			/>
			<path
				d="M148.367 28.6639V29.4048C148.685 29.4002 149 29.4621 149.292 29.5864C149.585 29.7106 149.848 29.8946 150.065 30.1265C150.269 30.3518 150.423 30.6172 150.518 30.9056C150.612 31.1939 150.645 31.4988 150.615 31.8007L148.946 50.0827C148.888 50.7659 147.981 51.3625 147.016 51.3817L140.908 51.4587C139.944 51.4587 139.114 50.9102 139.075 50.2559L137.84 31.9932C137.82 31.6815 137.863 31.3689 137.967 31.0744C138.072 30.7799 138.235 30.5098 138.448 30.2804C138.675 30.0373 138.95 29.8434 139.255 29.711C139.561 29.5785 139.89 29.5103 140.223 29.5107L148.328 29.3952V28.6543L148.367 28.6639ZM148.328 28.6543L140.223 28.7601C139.798 28.7594 139.377 28.8454 138.987 29.0129C138.596 29.1804 138.244 29.4258 137.952 29.7341C137.66 30.0423 137.435 30.4069 137.289 30.8053C137.144 31.2038 137.082 31.6276 137.107 32.0509L138.323 50.2752C138.435 50.858 138.761 51.3781 139.238 51.7339C139.714 52.0897 140.306 52.2558 140.899 52.1996H140.947L147.016 52.1226C147.624 52.1636 148.226 51.9877 148.716 51.6263C149.206 51.2649 149.55 50.7417 149.689 50.1501L151.358 31.8681C151.404 31.455 151.36 31.0368 151.229 30.6421C151.098 30.2475 150.884 29.8857 150.6 29.5814C150.316 29.2772 149.969 29.0377 149.584 28.8793C149.198 28.721 148.783 28.6475 148.367 28.6639L148.328 28.6543Z"
				fill="black"
			/>
			<path
				d="M139.992 102.533C139.647 102.534 139.306 102.461 138.991 102.32C138.677 102.179 138.396 101.973 138.168 101.715C137.873 101.375 137.653 100.976 137.523 100.544C137.393 100.113 137.357 99.6594 137.416 99.2131L139.017 83.2981C139.119 82.7522 139.412 82.2598 139.842 81.9077C140.273 81.5557 140.815 81.3665 141.371 81.3737L147.44 81.2871C147.987 81.2524 148.527 81.4242 148.952 81.7683C149.378 82.1124 149.658 82.6036 149.737 83.1442L150.952 99.0206C150.998 99.4783 150.947 99.9402 150.804 100.377C150.661 100.815 150.429 101.218 150.123 101.561C149.887 101.829 149.598 102.044 149.274 102.193C148.95 102.342 148.598 102.422 148.241 102.427L139.992 102.533Z"
				fill="white"
			/>
			<path
				d="M147.479 80.912V81.6529C147.924 81.6304 148.361 81.7719 148.708 82.0505C149.055 82.3291 149.288 82.7253 149.36 83.1636L150.586 99.04C150.624 99.4469 150.579 99.8573 150.453 100.246C150.327 100.635 150.123 100.994 149.852 101.301C149.648 101.531 149.399 101.716 149.12 101.845C148.841 101.974 148.539 102.044 148.232 102.052L139.992 102.158C139.698 102.159 139.408 102.099 139.14 101.979C138.872 101.86 138.633 101.684 138.438 101.465C138.181 101.16 137.99 100.805 137.877 100.422C137.764 100.039 137.732 99.6377 137.782 99.2421L139.384 83.3368C139.475 82.8785 139.725 82.467 140.09 82.1748C140.456 81.8825 140.913 81.7284 141.381 81.7395L147.45 81.6529V80.912H147.479ZM147.45 80.912L141.381 80.989C140.729 80.9807 140.095 81.2063 139.596 81.6249C139.096 82.0435 138.764 82.6271 138.66 83.2694L137.049 99.1748C136.967 99.6173 136.981 100.072 137.09 100.509C137.198 100.945 137.399 101.354 137.678 101.707C137.958 102.061 138.31 102.35 138.71 102.557C139.111 102.765 139.551 102.884 140.001 102.908L148.212 102.793C148.675 102.759 149.126 102.631 149.537 102.416C149.948 102.2 150.309 101.902 150.599 101.541C150.889 101.18 151.101 100.762 151.222 100.315C151.342 99.8685 151.369 99.4015 151.3 98.9438L150.074 83.077C149.991 82.4497 149.675 81.8761 149.19 81.4686C148.705 81.061 148.084 80.8488 147.45 80.8735V80.912Z"
				fill="black"
			/>
			<path
				d="M186.343 111.145C175.083 111.145 153.538 100.176 132.022 82.6729C118.89 71.9635 107.717 60.4747 100.578 50.2849C93.4377 40.0951 91.0931 32.1761 94.2385 28.3369L94.8174 28.8084C91.9229 32.3108 94.2674 39.9893 101.185 49.8519C108.296 59.9936 119.411 71.4439 132.533 82.0956C159.424 103.996 186.295 115.773 192.422 108.258L193.001 108.73C191.621 110.375 189.344 111.145 186.343 111.145Z"
				fill="white"
			/>
			<path
				d="M197.815 99.1748C199.393 99.1748 200.671 97.8996 200.671 96.3267C200.671 94.7537 199.393 93.4785 197.815 93.4785C196.238 93.4785 194.959 94.7537 194.959 96.3267C194.959 97.8996 196.238 99.1748 197.815 99.1748Z"
				fill="white"
			/>
			<path
				d="M197.816 93.8439C198.308 93.8439 198.789 93.9895 199.199 94.2623C199.608 94.5351 199.927 94.9228 200.115 95.3764C200.304 95.8301 200.353 96.3292 200.257 96.8108C200.161 97.2923 199.924 97.7347 199.576 98.0818C199.228 98.429 198.784 98.6655 198.301 98.7613C197.818 98.857 197.318 98.8079 196.863 98.62C196.408 98.4321 196.019 98.1139 195.746 97.7057C195.472 97.2974 195.326 96.8174 195.326 96.3264C195.329 95.6688 195.592 95.0389 196.058 94.5739C196.525 94.1088 197.156 93.8465 197.816 93.8439ZM197.816 93.103C197.176 93.1011 196.55 93.2886 196.017 93.6416C195.484 93.9946 195.069 94.4974 194.823 95.0862C194.576 95.6751 194.511 96.3235 194.635 96.9494C194.758 97.5753 195.065 98.1506 195.517 98.6023C195.969 99.0541 196.545 99.362 197.172 99.4872C197.799 99.6124 198.449 99.5491 199.041 99.3054C199.632 99.0617 200.137 98.6486 200.493 98.1183C200.848 97.588 201.038 96.9644 201.038 96.3264C201.031 95.4782 200.688 94.6672 200.085 94.0692C199.482 93.4712 198.666 93.1344 197.816 93.1319V93.103Z"
				fill="black"
			/>
			<path
				d="M83.8377 71.8766L81.6668 60.7053L70.4648 58.5403L81.6668 56.3754L83.8377 45.2041L86.0086 56.3754L97.2009 58.5403L86.0086 60.7053L83.8377 71.8766ZM74.3821 58.5403L82.2939 60.0703L83.8377 67.97L85.3718 60.0703L93.2836 58.5403L85.3718 57.0104L83.8377 49.1107L82.2939 57.0104L74.3821 58.5403Z"
				fill="black"
			/>
			<path
				d="M205.303 35.3992L206.827 43.02L206.924 43.5107L207.416 43.6069L215.058 45.0791L207.416 46.5609L206.924 46.6571L206.827 47.1478L205.351 54.7589L203.865 47.1478L203.769 46.6571L203.277 46.5609L195.645 45.0791L203.277 43.6069L203.769 43.5107L203.865 43.02L205.303 35.3992ZM205.303 31.4927L203.084 42.8756L191.679 45.0791L203.084 47.2922L205.303 58.6751L207.512 47.2922L218.927 45.0791L207.512 42.8756L205.303 31.4927Z"
				fill="black"
			/>
			<path
				d="M196.156 33.9463L195.548 37.0542L192.422 37.6604L195.548 38.2666L196.156 41.3745L196.754 38.2666L199.88 37.6604L196.754 37.0542L196.156 33.9463Z"
				fill="black"
			/>
			<path
				d="M197.844 68.894L198.365 71.5497L201.028 72.0693L198.365 72.5793L197.844 75.235L197.333 72.5793L194.67 72.0693L197.333 71.5497L197.844 68.894Z"
				fill="white"
			/>
			<path
				d="M197.844 77.1884L197.015 72.9258L192.711 72.0983L197.015 71.2612L197.844 66.9697L198.684 71.2612L202.987 72.0983L198.684 72.9258L197.844 77.1884ZM196.629 72.0694L197.651 72.2619L197.844 73.2818L198.047 72.2619L199.07 72.0694L198.047 71.8674L197.844 70.8474L197.651 71.8674L196.629 72.0694Z"
				fill="black"
			/>
			<path
				d="M20.8037 42.0195C23.6011 40.8664 26.6652 40.5131 29.6527 40.9992C32.6401 41.4852 35.4327 42.7915 37.7176 44.7714C39.9388 46.8228 41.5438 49.4501 42.3532 52.3593C43.1626 55.2685 43.1444 58.345 42.3006 61.2444C45.0989 61.8532 47.7472 63.0127 50.0905 64.6551C52.4337 66.2975 54.4248 68.3897 55.9469 70.8092C57.4691 73.2287 58.4918 75.9268 58.9551 78.7454C59.4184 81.5641 59.3131 84.4466 58.6452 87.2241"
				fill="white"
			/>
			<path
				d="M59.0023 87.3011L58.24 87.1279C58.8957 84.4018 59.0001 81.5727 58.5471 78.8058C58.0942 76.039 57.0928 73.39 55.6017 71.0134C54.1106 68.6368 52.1596 66.5804 49.8626 64.9642C47.5656 63.348 44.9686 62.2045 42.2235 61.6005L41.8376 61.5139L41.963 61.129C42.7812 58.2922 42.7941 55.2846 42.0003 52.4408C41.2065 49.5971 39.6371 47.0288 37.4668 45.0216C35.227 43.1026 32.4986 41.8388 29.5833 41.3701C26.668 40.9014 23.6796 41.246 20.9485 42.3659L20.6108 41.6827C23.4781 40.4739 26.6294 40.0972 29.702 40.596C32.7745 41.0947 35.6433 42.4487 37.9782 44.502C40.2199 46.5404 41.8559 49.1547 42.7068 52.0586C43.5577 54.9625 43.5908 58.044 42.8024 60.9654C45.6004 61.6333 48.239 62.8444 50.5676 64.5295C52.8961 66.2146 54.8689 68.3407 56.3733 70.7863C57.8777 73.232 58.8841 75.9492 59.3352 78.7829C59.7863 81.6166 59.6732 84.5111 59.0023 87.3011Z"
				fill="black"
			/>
			<path
				d="M144.382 4.64697H143.639V18.6568H144.382V4.64697Z"
				fill="black"
			/>
			<path
				d="M163.023 21.6304L168.658 11.6812L163.023 21.6304Z"
				fill="white"
			/>
			<path
				d="M168.311 11.4963L162.688 21.4458L163.335 21.8096L168.959 11.8601L168.311 11.4963Z"
				fill="black"
			/>
			<rect
				x="231.566"
				y="48.0718"
				width="27.4404"
				height="33.023"
				fill="url(#pattern1_1253_33753)"
			/>
			<path
				d="M259.952 41.7307C256.962 41.9964 254.071 42.9299 251.493 44.462C248.915 45.9942 246.715 48.0856 245.058 50.5811C243.401 53.0767 242.329 55.9123 241.92 58.8776C241.512 61.8429 241.779 64.8618 242.7 67.7104C234.692 64.9488 224.889 69.9138 222.39 77.9771C214.768 77.0149 207.175 84.1353 207.724 91.7849L274.685 92.6508L273.161 41.2207L259.952 41.7307Z"
				fill="white"
			/>
			<path
				d="M207.358 91.833C207.318 89.91 207.676 87.9994 208.411 86.221C209.146 84.4425 210.241 82.8345 211.627 81.4976C213.014 80.1608 214.663 79.1239 216.47 78.4519C218.277 77.7799 220.204 77.4872 222.13 77.5923C223.591 73.7004 226.441 70.4831 230.134 68.5566C233.826 66.6302 238.102 66.1302 242.141 67.1523C241.321 64.2786 241.147 61.2601 241.631 58.3117C242.115 55.3633 243.245 52.5576 244.94 50.0943C246.635 47.631 248.854 45.5708 251.439 44.0603C254.024 42.5498 256.911 41.6263 259.894 41.3555L259.952 42.0964C257.017 42.36 254.18 43.2789 251.65 44.785C249.12 46.2911 246.962 48.3457 245.337 50.7966C243.711 53.2474 242.66 56.0317 242.26 58.943C241.861 61.8542 242.123 64.8179 243.029 67.6142L243.26 68.3166L242.556 68.076C238.593 66.894 234.327 67.2766 230.64 69.1448C226.952 71.0129 224.127 74.2235 222.747 78.1119L222.661 78.4102H222.342C220.507 78.2723 218.663 78.5173 216.928 79.1295C215.193 79.7418 213.605 80.7079 212.265 81.9663C210.925 83.2247 209.863 84.7477 209.146 86.4382C208.429 88.1287 208.073 89.9496 208.101 91.7849L207.358 91.833Z"
				fill="black"
			/>
			<path
				d="M95.3359 43.6788C99.7776 34.1125 106.948 26.0745 115.942 20.5813C124.935 15.0881 135.347 12.3865 145.86 12.8179C156.374 13.2494 166.517 16.7946 175.008 23.0052C183.498 29.2159 189.954 37.8131 193.559 47.7096C197.164 57.6061 197.757 68.3575 195.262 78.6041C192.766 88.8508 187.296 98.1325 179.541 105.275C171.787 112.419 162.097 117.102 151.697 118.734C141.297 120.366 130.654 118.872 121.114 114.443L121.431 113.76C130.837 118.127 141.329 119.599 151.583 117.991C161.836 116.382 171.389 111.764 179.034 104.722C186.679 97.6801 192.072 88.5294 194.532 78.4273C196.992 68.3253 196.408 57.7257 192.854 47.9688C189.299 38.2119 182.935 29.7361 174.564 23.6131C166.194 17.49 156.193 13.9949 145.828 13.5695C135.463 13.1441 125.198 15.8077 116.332 21.2234C107.465 26.639 100.396 34.5636 96.0166 43.9949L95.3359 43.6788Z"
				fill="black"
			/>
			<path
				d="M197.304 76.0818C200.906 76.0818 203.827 73.1696 203.827 69.5773C203.827 65.9849 200.906 63.0728 197.304 63.0728C193.702 63.0728 190.782 65.9849 190.782 69.5773C190.782 73.1696 193.702 76.0818 197.304 76.0818Z"
				fill="white"
			/>
			<path
				d="M197.285 76.4474C195.948 76.4442 194.642 76.0535 193.524 75.3229C192.407 74.5923 191.526 73.5532 190.99 72.3324C190.454 71.1116 190.286 69.7617 190.506 68.4472C190.726 67.1327 191.324 65.9103 192.228 64.929C193.132 63.9476 194.303 63.2497 195.598 62.9203C196.893 62.5908 198.256 62.6441 199.521 63.0735C200.786 63.5029 201.899 64.29 202.723 65.3388C203.547 66.3877 204.048 67.653 204.164 68.9806C204.244 69.88 204.144 70.7861 203.872 71.647C203.599 72.508 203.159 73.3069 202.577 73.9978C201.994 74.6888 201.28 75.2583 200.477 75.6737C199.673 76.0891 198.795 76.3422 197.893 76.4185C197.693 76.4377 197.491 76.4474 197.285 76.4474ZM197.285 63.4479C197.105 63.4383 196.924 63.4383 196.744 63.4479C195.533 63.5514 194.38 64.0107 193.43 64.7679C192.481 65.5251 191.778 66.5461 191.41 67.7017C191.043 68.8574 191.027 70.0958 191.365 71.2603C191.704 72.4248 192.381 73.4631 193.311 74.2439C194.241 75.0247 195.382 75.5128 196.59 75.6467C197.799 75.7805 199.02 75.5539 200.099 74.9957C201.178 74.4374 202.067 73.5725 202.653 72.5104C203.239 71.4483 203.497 70.2366 203.392 69.0287C203.264 67.5015 202.565 66.0781 201.434 65.0409C200.302 64.0036 198.822 63.4281 197.285 63.4287V63.4479Z"
				fill="black"
			/>
			<path
				d="M203.797 69.0095C204.164 73.3202 198.848 76.7071 197.864 76.0528C197.256 75.6679 198.539 73.9456 198.471 70.5394C198.385 66.017 196.021 63.7173 196.735 63.1015C197.68 62.2836 203.44 64.718 203.797 69.0095Z"
				fill="black"
			/>
			<path
				d="M198.144 76.4955C197.962 76.4999 197.782 76.4567 197.623 76.3705C197.121 76.0433 197.285 75.4082 197.517 74.5423C198.485 71.3472 198.188 67.9033 196.687 64.9202C196.243 63.9002 195.953 63.217 196.455 62.7744C196.957 62.3318 198.472 62.7167 199.041 62.9476C201.405 63.9098 203.865 66.1229 204.126 68.9422C204.406 72.2137 201.685 74.7732 200.025 75.7739C199.463 76.158 198.819 76.4052 198.144 76.4955ZM197.275 63.3133C197.162 63.3005 197.047 63.3241 196.947 63.3806C196.87 63.5153 197.16 64.1793 197.372 64.6604C198.252 66.4968 198.742 68.4953 198.809 70.5298C198.831 71.9494 198.636 73.3641 198.23 74.7251C198.117 75.0602 198.055 75.4106 198.047 75.7643C198.671 75.7199 199.266 75.4884 199.755 75.1003C201.685 73.8687 203.614 71.5209 203.383 69.048C203.142 66.1614 200.363 64.314 198.761 63.6693C198.305 63.4605 197.815 63.3366 197.314 63.3036L197.275 63.3133Z"
				fill="black"
			/>
			<path
				d="M138.301 86.7591L137.863 87.3579L156.758 101.088L157.195 100.489L138.301 86.7591Z"
				fill="black"
			/>
			<rect
				x="157.089"
				y="75.3794"
				width="52.7967"
				height="51.1896"
				fill="url(#pattern2_1253_33753)"
			/>
			<path
				d="M37.6984 94.3154C41.0754 96.8364 44.9734 99.0398 49.2284 99.1264C53.4834 99.213 58.0375 96.5188 58.6646 92.391C59.0699 89.7737 57.8831 87.2046 56.7349 84.8087C51.7659 74.6382 46.1505 63.746 35.8555 58.4923C32.4496 56.7603 27.9823 55.8558 24.9431 58.1459C22.2897 60.1377 21.7301 63.7941 21.8169 67.056C22.0237 72.9796 23.5916 78.7767 26.4 84.0005C28.7639 88.571 33.5399 91.2074 37.6984 94.3154Z"
				fill="white"
			/>
			<path
				d="M60.1699 91.6502C64.724 87.0508 72.52 85.2707 78.9749 87.3683C85.4297 89.466 90.1382 95.3162 90.3215 101.465C96.622 95.5471 107.882 94.5849 115.321 99.319C122.76 104.053 125.442 113.896 121.274 121.161"
				fill="white"
			/>
			<path
				d="M121.621 121.344L120.974 120.969C125.065 113.849 122.451 104.284 115.185 99.6368C107.92 94.9893 96.8532 95.913 90.6299 101.734L90.0317 102.302V101.475C89.8001 95.4415 85.2557 89.7933 78.8877 87.7246C72.5197 85.6558 64.9938 87.359 60.4687 91.9198L59.938 91.3906C64.6079 86.6662 72.4811 84.8668 79.1192 87.0222C85.4969 89.0909 90.1378 94.6333 90.6975 100.666C97.2198 95.0951 108.2 94.3157 115.571 99.0113C123.184 103.861 125.905 113.887 121.621 121.344Z"
				fill="black"
			/>
		</g>
		<defs>
			<pattern
				id="pattern0_1253_33753"
				patternContentUnits="objectBoundingBox"
				width="1"
				height="1"
			>
				<use
					xlinkHref="#image0_1253_33753"
					transform="scale(0.00574713 0.00581395)"
				/>
			</pattern>
			<pattern
				id="pattern1_1253_33753"
				patternContentUnits="objectBoundingBox"
				width="1"
				height="1"
			>
				<use
					xlinkHref="#image1_1253_33753"
					transform="scale(0.00421941 0.0034965)"
				/>
			</pattern>
			<pattern
				id="pattern2_1253_33753"
				patternContentUnits="objectBoundingBox"
				width="1"
				height="1"
			>
				<use
					xlinkHref="#image2_1253_33753"
					transform="scale(0.00347222 0.00357143)"
				/>
			</pattern>
			<clipPath id="clip0_1253_33753">
				<rect
					width="262.44"
					height="130.861"
					fill="white"
					transform="translate(16.7515 0.759766)"
				/>
			</clipPath>
			<image
				id="image0_1253_33753"
				width="174"
				height="172"
				preserveAspectRatio="none"
				xlinkHref="data:image/png;base64,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"
			/>
			<image
				id="image1_1253_33753"
				width="237"
				height="286"
				preserveAspectRatio="none"
				xlinkHref="data:image/png;base64,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"
			/>
			<image
				id="image2_1253_33753"
				width="288"
				height="280"
				preserveAspectRatio="none"
				xlinkHref="data:image/png;base64,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"
			/>
		</defs>
	</svg>
);
